clear 

addpath('./Functions/')

datadir = 'Data' ;
subjects = {'S1','S2','S3','S4','S5','S6'} ;

n = length(subjects) ;

figure()

for i = 1:n
    
    % Load data
    load(fullfile(datadir,[subjects{i}]));
    dFR = choiceMat2Struct(dataFR) ; % Organize
    
    
    %%% FR data %%%
    
    % Calculate mean RT and prop. rightward choice
    coh = [dFR.coherence];
    meanRT = nanmean([dFR.RTs]);
    pRight = nansum([dFR.choice]) ./ [dFR.nTrials] ;
    
    % Plot
    subplot(3,n,i)
    plot(coh, meanRT, 'ko-','markerfacecolor','k')
    xlim([-.512 .512])
    xlabel('Motion strength (%coh')
    ylabel('RT (s)')
    title(subjects{i})
    
    
    subplot(3,n,i+6)
    plot(coh, pRight, 'ko-', 'markerfacecolor','k')
    xlim([-.512 .512])
    xlabel('Motion strength (%coh')
    ylabel('Prop. rightward choice')
    
    
    
    %%% VSD data %%%
    
    % Calculate sensitivity for VSD data    
    dataVSD(:,3) = dataVSD(:,3)/1000 ; % Convert ms to s
    
    % create log-spaced sliding window
    binEdges = [10.^(log10(.03):.01:.1)' 10.^(log10(.03)+.1:.01:.2)']; 
    binCenter = mean(binEdges, 2);
    
    % Preallocate
    dataSens   = nan(1,length(binCenter)) ;
    dataSensSE = nan(1,length(binCenter)) ;
    
    % Loop through each bin and perform logisitc regression
    for j = 1:length(binCenter)
        
        l = (dataVSD(:,3) >= binEdges(j,1)) & (dataVSD(:,3) <= binEdges(j,2)) ;
        x = dataVSD(l,1) ;
        y = dataVSD(l,2) ;
        
        if sum(l) > 50
            
            [w,~,stats] = glmfit(x,y,'binomial','logit') ;
            dataSens(j)   = w(2) ;
            dataSensSE(j) = stats.se(2) ;
            
        end
        
    end
    
    % Plot
    subplot(3,n,i+12)
    loglog(binCenter, dataSens,'k-','linewidth',1.5)
    hold on
    plot(binCenter, dataSens + dataSensSE, 'k--')
    plot(binCenter, dataSens - dataSensSE, 'k--')
    
    set(gca,'xscale','log')
    set(gca,'yscale','log')

    xlim([.07 1])
    set(gca, 'xtick', [.05 .1 .2 .4 .8]) ;
    set(gca, 'ytick', [5 10 20 40]) ;
    xlabel('Stimulus duration (s)')
    ylabel('Sensitivity') 
    ylim([2 60])
    
    
end

